<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\SubscribewithGoogle;

class Publication extends \Google\Site_Kit_Dependencies\Google\Collection
{
    protected $collection_key = 'verifiedDomains';
    protected $contentPolicyStatusType = \Google\Site_Kit_Dependencies\Google\Service\SubscribewithGoogle\ContentPolicyStatus::class;
    protected $contentPolicyStatusDataType = '';
    /**
     * @var string
     */
    public $displayName;
    /**
     * @var string
     */
    public $onboardingState;
    protected $paymentOptionsType = \Google\Site_Kit_Dependencies\Google\Service\SubscribewithGoogle\PaymentOptions::class;
    protected $paymentOptionsDataType = '';
    protected $productsType = \Google\Site_Kit_Dependencies\Google\Service\SubscribewithGoogle\Product::class;
    protected $productsDataType = 'array';
    /**
     * @var string
     */
    public $publicationId;
    /**
     * @var string[]
     */
    public $verifiedDomains;
    /**
     * @param ContentPolicyStatus
     */
    public function setContentPolicyStatus(\Google\Site_Kit_Dependencies\Google\Service\SubscribewithGoogle\ContentPolicyStatus $contentPolicyStatus)
    {
        $this->contentPolicyStatus = $contentPolicyStatus;
    }
    /**
     * @return ContentPolicyStatus
     */
    public function getContentPolicyStatus()
    {
        return $this->contentPolicyStatus;
    }
    /**
     * @param string
     */
    public function setDisplayName($displayName)
    {
        $this->displayName = $displayName;
    }
    /**
     * @return string
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * @param string
     */
    public function setOnboardingState($onboardingState)
    {
        $this->onboardingState = $onboardingState;
    }
    /**
     * @return string
     */
    public function getOnboardingState()
    {
        return $this->onboardingState;
    }
    /**
     * @param PaymentOptions
     */
    public function setPaymentOptions(\Google\Site_Kit_Dependencies\Google\Service\SubscribewithGoogle\PaymentOptions $paymentOptions)
    {
        $this->paymentOptions = $paymentOptions;
    }
    /**
     * @return PaymentOptions
     */
    public function getPaymentOptions()
    {
        return $this->paymentOptions;
    }
    /**
     * @param Product[]
     */
    public function setProducts($products)
    {
        $this->products = $products;
    }
    /**
     * @return Product[]
     */
    public function getProducts()
    {
        return $this->products;
    }
    /**
     * @param string
     */
    public function setPublicationId($publicationId)
    {
        $this->publicationId = $publicationId;
    }
    /**
     * @return string
     */
    public function getPublicationId()
    {
        return $this->publicationId;
    }
    /**
     * @param string[]
     */
    public function setVerifiedDomains($verifiedDomains)
    {
        $this->verifiedDomains = $verifiedDomains;
    }
    /**
     * @return string[]
     */
    public function getVerifiedDomains()
    {
        return $this->verifiedDomains;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\SubscribewithGoogle\Publication::class, 'Google\\Site_Kit_Dependencies\\Google_Service_SubscribewithGoogle_Publication');
